/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.utility.discovery.controller;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.jfoenix.controls.JFXButton;
import com.tplink.smb.ecsp.common.DeviceType;
import com.tplink.utility.a.a.h;
import com.tplink.utility.common.obfuscate.KeepClass;
import com.tplink.utility.common.protocol.packet.body.datagram.BaseConfigRequest;
import com.tplink.utility.discovery.context.d;
import com.tplink.utility.discovery.context.model.DeviceModel;
import com.tplink.utility.discovery.context.model.DeviceSetting;
import com.tplink.utility.discovery.context.model.DeviceStatus;
import com.tplink.utility.discovery.controller.a;
import com.tplink.utility.discovery.d.e;
import com.tplink.utility.discovery.d.g;
import com.tplink.utility.discovery.d.i;
import com.tplink.utility.discovery.event.EventQueueManager;
import com.tplink.utility.discovery.event.b;
import com.tplink.utility.discovery.ui.Msg;
import com.tplink.utility.server.cache.AdoptInfoDTO;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@KeepClass
public class SettingController
implements a {
    private static final Logger log = LoggerFactory.getLogger(SettingController.class);
    ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("thread-call-runner-%d").build();
    ExecutorService executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), this.namedThreadFactory);
    private DeviceModel device;
    @FXML
    private TitledPane titledPane;
    @FXML
    private AnchorPane mainPane;
    @FXML
    private GridPane gridPane;
    @FXML
    private Label status;
    @FXML
    private Label model;
    @FXML
    private Label ipLabel;
    @FXML
    private Label macLabel;
    @FXML
    private Label setInformIp;
    @FXML
    private Label usernameLabel;
    @FXML
    private Label passwordLabel;
    @FXML
    private Label statusValue;
    @FXML
    private Label modelValue;
    @FXML
    private Label ipValue;
    @FXML
    private Label macValue;
    @FXML
    private TextField setInformIpField;
    @FXML
    private TextField usernameField;
    @FXML
    private PasswordField passwordField;
    @FXML
    private JFXButton apply;
    @FXML
    private JFXButton cancel;
    @FXML
    private JFXButton OK;
    private double mouseDragOffsetX;
    private double mouseDragOffsetY;
    private final String settingWindowTitle = "setting.window.title";

    public void onCreate() {
        double msgW = this.titledPane.getPrefWidth();
        double msgH = this.titledPane.getPrefHeight();
        this.OK.setVisible(false);
        this.statusValue.setText(this.device.getStatus());
        this.modelValue.setText(this.device.getModel());
        this.modelValue.setTooltip(new Tooltip(this.device.getModel()));
        this.ipValue.setText(this.device.getIp());
        this.ipValue.setTooltip(new Tooltip(this.device.getIp()));
        this.macValue.setText(this.device.getMac());
        this.macValue.setTooltip(new Tooltip(this.device.getMac()));
        this.titledPane.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode() == KeyCode.ENTER && !this.apply.isDisabled()) {
                this.a();
                keyEvent.consume();
            }
        });
        this.titledPane.setOnMousePressed(mouseEvent -> {
            this.mouseDragOffsetX = mouseEvent.getX();
            this.mouseDragOffsetY = mouseEvent.getY();
        });
        this.titledPane.setOnMouseDragged(mouseEvent -> {
            this.titledPane.setLayoutX(mouseEvent.getSceneX() - this.mouseDragOffsetX - (822.0 - msgW) / 2.0);
            this.titledPane.setLayoutY(mouseEvent.getSceneY() - this.mouseDragOffsetY - (532.0 - msgH) / 2.0);
        });
        this.apply.setOnAction(actionEvent -> this.a());
        this.apply.setDisable(true);
        g.a((Node)this.apply, (TextField[])new TextField[]{this.passwordField, this.setInformIpField, this.usernameField});
        this.cancel.setOnAction(event -> {
            com.tplink.utility.discovery.ui.a.b().a();
            com.tplink.utility.discovery.ui.a.a((String)this.device.getMac());
        });
        this.OK.setOnAction(event -> {
            com.tplink.utility.discovery.ui.a.b().a();
            com.tplink.utility.discovery.ui.a.a((String)this.device.getMac());
        });
    }

    public void setDevice(DeviceModel device) {
        this.device = device;
    }

    private void a() {
        if (!i.d((String)this.setInformIpField.getText())) {
            Msg.setTitle((String)com.tplink.utility.discovery.b.a.a((String)"setting.window.title"));
            Msg.a((String)com.tplink.utility.discovery.b.a.a((String)"setting.error.invalidHostname"));
            return;
        }
        DeviceModel newModel = d.b((String)this.device.getMac());
        if (newModel == null) {
            Msg.setTitle((String)com.tplink.utility.discovery.b.a.a((String)"setting.window.title"));
            Msg.a((String)com.tplink.utility.discovery.b.a.a((String)"g.error.deviceUnreachable"));
            return;
        }
        if (!newModel.getReachable()) {
            Msg.setTitle((String)com.tplink.utility.discovery.b.a.a((String)"setting.window.title"));
            Msg.a((String)com.tplink.utility.discovery.b.a.a((String)"g.error.deviceBusy"));
            log.debug("Device {} is busy, please retry later.", (Object)newModel.getMac());
            return;
        }
        if (newModel.isConfiguring()) {
            Msg.setTitle((String)com.tplink.utility.discovery.b.a.a((String)"setting.window.title"));
            Msg.a((String)com.tplink.utility.discovery.b.a.a((String)"g.error.adopt"));
            return;
        }
        this.apply.setDisable(true);
        this.b();
    }

    private void b() {
        String username = this.usernameField.getText();
        String password = this.passwordField.getText();
        com.tplink.utility.common.c.a authentication = new com.tplink.utility.common.c.a();
        authentication.a(username);
        authentication.b(password);
        authentication.d(this.device.getIp());
        authentication.c(this.device.getMac());
        BaseConfigRequest configBody = e.a((String)this.setInformIpField.getText(), (DeviceType)d.b((String)this.device.getMac()).getType(), (String)d.b((String)this.device.getMac()).getProtocolVersion());
        DeviceSetting deviceSetting = new DeviceSetting(configBody, DeviceStatus.PENDING, e.a((String)this.setInformIpField.getText()));
        d.a((String)this.device.getMac(), (DeviceSetting)deviceSetting);
        AdoptInfoDTO adoptInfoDTO = new AdoptInfoDTO(authentication, this.device.getType(), this.device.getEcspVersion());
        com.tplink.utility.server.cache.a.a((String)this.device.getMac(), (AdoptInfoDTO)adoptInfoDTO);
        String mac = this.device.getMac();
        DeviceModel newModel = d.b((String)mac);
        if (newModel == null) {
            log.debug("No device for mac: {}", (Object)mac);
            Msg.setTitle((String)com.tplink.utility.discovery.b.a.a((String)"setting.window.title"));
            Msg.a((String)com.tplink.utility.discovery.b.a.a((String)"g.error.deviceUnreachable"), event -> {
                com.tplink.utility.discovery.event.a msg = new com.tplink.utility.discovery.event.a(mac, b.b, newModel);
                try {
                    EventQueueManager.a((com.tplink.utility.discovery.event.a)msg);
                }
                catch (InterruptedException e2) {
                    log.error("Exception: ", (Throwable)e2);
                    Thread.currentThread().interrupt();
                }
            });
        } else {
            this.executor.execute(() -> {
                if ("v1".equals(newModel.getProtocolVersion())) {
                    com.tplink.utility.discovery.event.d.a((h)h.l, com.tplink.utility.common.c.a.class, (Object)authentication, (String)newModel.getMac(), (String)newModel.getEcspVersion(), (DeviceType)newModel.getType());
                } else if ("v2".equals(this.device.getProtocolVersion())) {
                    com.tplink.utility.discovery.event.d.a((h)h.p, com.tplink.utility.common.c.a.class, (Object)authentication, (String)newModel.getMac(), (String)newModel.getEcspVersion(), (DeviceType)newModel.getType());
                }
            });
            newModel.setStatus(DeviceStatus.ADOPTING.getName());
            newModel.setLastSeen(Long.valueOf(System.currentTimeMillis()));
            com.tplink.utility.discovery.event.a msg = new com.tplink.utility.discovery.event.a(mac, b.a, newModel);
            try {
                EventQueueManager.a((com.tplink.utility.discovery.event.a)msg);
            }
            catch (InterruptedException e2) {
                log.error("Exception: ", (Throwable)e2);
                Thread.currentThread().interrupt();
            }
            this.updateDeviceStatus(DeviceStatus.ADOPTING.getName());
        }
    }

    public void updateDeviceStatus(String status) {
        Platform.runLater(() -> {
            this.statusValue.setText(status);
            this.statusValue.setTextFill((Paint)Color.RED);
        });
    }

    public void updateButtonText(String status) {
        Platform.runLater(() -> {
            if (!status.equals(this.statusValue.getText())) {
                if (status.equals(DeviceStatus.ADOPTING.getName()) || status.equals(DeviceStatus.CONFIGURING.getName()) || status.equals(DeviceStatus.PENDING.getName())) {
                    this.cancel.setVisible(true);
                    this.apply.setVisible(true);
                    this.apply.setDisable(true);
                    this.OK.setVisible(false);
                } else if (status.equals(DeviceStatus.SETTING_SUCCEED.getName())) {
                    this.cancel.setVisible(false);
                    this.apply.setVisible(false);
                    this.OK.setVisible(true);
                } else {
                    this.apply.setText("Retry");
                    this.apply.setDisable(false);
                }
            }
        });
    }
}

