/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.utility.discovery.controller;

import com.tplink.utility.common.obfuscate.KeepClass;
import com.tplink.utility.discovery.context.model.DeviceModel;
import com.tplink.utility.discovery.controller.DiscoveryController;
import com.tplink.utility.discovery.d.d;
import com.tplink.utility.discovery.d.g;
import com.tplink.utility.discovery.ui.Msg;
import java.util.ArrayList;
import java.util.Collection;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Region;
import javafx.util.Callback;
import org.springframework.util.CollectionUtils;

@KeepClass
public class DiscoveryController
implements com.tplink.utility.discovery.controller.a {
    private static final int TABLE_CELL_HEIGHT = 32;
    private static final int TABLE_HEADER_HEIGHT = 26;
    @FXML
    private TableView<DeviceModel> deviceTable;
    @FXML
    private TableColumn<DeviceModel, Object> colSel;
    @FXML
    private TableColumn<DeviceModel, String> colMac;
    @FXML
    private TableColumn<DeviceModel, String> colType;
    @FXML
    private TableColumn<DeviceModel, String> colIp;
    @FXML
    private TableColumn<DeviceModel, String> colModel;
    @FXML
    private TableColumn<DeviceModel, String> colVersion;
    @FXML
    private TableColumn<DeviceModel, String> colStatus;
    @FXML
    private TableColumn<DeviceModel, String> colSetting;
    @FXML
    private Button selectAll;
    @FXML
    private Button batchSetting;
    @FXML
    private Label totalDevice;
    @FXML
    private TitledPane discoveryTitledPane;
    @FXML
    private TextField searcher;
    @FXML
    private Button searchBtn;
    @FXML
    private TextField clear;
    @FXML
    private Button clearBtn;
    ObservableList<DeviceModel> content;

    public void onCreate() {
        this.discoveryTitledPane.setId("page-discovery");
        this.a();
        this.searcher.addEventHandler(KeyEvent.KEY_PRESSED, event -> {
            KeyCode code = event.getCode();
            if (code == KeyCode.ENTER) {
                String searchKey = this.searcher.getText().trim();
                this.a(searchKey);
            }
        });
    }

    private void a() {
        this.deviceTable.setId("discovery-table");
        this.deviceTable.setPlaceholder((Node)new Label(""));
        this.colSel.setCellValueFactory((Callback)new PropertyValueFactory("selected"));
        this.colSel.setCellFactory(param -> new a(this));
        this.colMac.setCellValueFactory((Callback)new PropertyValueFactory("mac"));
        this.colType.setCellValueFactory((Callback)new PropertyValueFactory("type"));
        this.colIp.setCellValueFactory((Callback)new PropertyValueFactory("ip"));
        this.colModel.setCellValueFactory((Callback)new PropertyValueFactory("model"));
        this.colVersion.setCellValueFactory((Callback)new PropertyValueFactory("version"));
        this.colStatus.setCellValueFactory((Callback)new PropertyValueFactory("status"));
        this.colSetting.setCellValueFactory((Callback)new PropertyValueFactory("settingButton"));
        this.colSetting.setCellFactory(param -> new b(this));
        com.tplink.utility.discovery.ui.a.d().heightProperty().addListener((arg0, arg1, newValue) -> {
            double adjustedHeight = newValue.doubleValue() - 170.0;
            this.deviceTable.setPrefHeight(adjustedHeight);
        });
        this.deviceTable.heightProperty().addListener((arg0, arg1, arg2) -> this.a(arg2.doubleValue()));
        g.a((TableView)this.deviceTable);
        this.configureDeviceTable();
    }

    public void configureDeviceTable() {
        Platform.runLater(() -> {
            this.content = d.c((String)d.a());
            this.b();
            this.totalDevice.setText(com.tplink.utility.discovery.b.a.a((String)"discover.label.totalAp") + this.content.size());
            this.a(this.deviceTable.getPrefHeight());
        });
    }

    private void a(String searchKey) {
        if (d.b((String)searchKey)) {
            this.content = d.c((String)searchKey);
            this.b();
            this.a(this.deviceTable.getPrefHeight());
            this.totalDevice.setText(com.tplink.utility.discovery.b.a.a((String)"discover.label.totalAp") + this.content.size());
        }
    }

    private void b() {
        if (this.content.isEmpty()) {
            this.deviceTable.setId("null-discovery-table");
            this.deviceTable.setItems(com.tplink.utility.discovery.context.d.b());
        } else {
            this.deviceTable.setId("discovery-table");
            this.deviceTable.setItems(this.content);
        }
    }

    private void a(double height) {
        boolean isScroll;
        if (this.deviceTable.getItems() == null) {
            isScroll = false;
        } else {
            int itemNum = this.deviceTable.getItems().size();
            boolean bl = isScroll = (double)(itemNum * 32 + 26 + (itemNum + 1) / 2 + 1) > height;
        }
        if (isScroll) {
            this.colMac.prefWidthProperty().bind((ObservableValue)this.deviceTable.widthProperty().subtract(58).divide(6.666666666666667));
            this.colType.prefWidthProperty().bind((ObservableValue)this.deviceTable.widthProperty().subtract(58).divide(6.666666666666667));
            this.colIp.prefWidthProperty().bind((ObservableValue)this.deviceTable.widthProperty().subtract(58).divide(6.666666666666667));
            this.colModel.prefWidthProperty().bind((ObservableValue)this.deviceTable.widthProperty().subtract(58).divide(7.142857142857142));
            this.colVersion.prefWidthProperty().bind((ObservableValue)this.deviceTable.widthProperty().subtract(58).divide(7.142857142857142));
            this.colStatus.prefWidthProperty().bind((ObservableValue)this.deviceTable.widthProperty().subtract(58).divide(7.692307692307692));
            this.colSetting.prefWidthProperty().bind((ObservableValue)this.deviceTable.widthProperty().subtract(58).divide(7.142857142857142));
        } else {
            this.colMac.prefWidthProperty().bind((ObservableValue)this.deviceTable.widthProperty().subtract(40).divide(6.666666666666667).subtract(0.5));
            this.colType.prefWidthProperty().bind((ObservableValue)this.deviceTable.widthProperty().subtract(40).divide(6.666666666666667).subtract(0.5));
            this.colIp.prefWidthProperty().bind((ObservableValue)this.deviceTable.widthProperty().subtract(40).divide(6.666666666666667).subtract(0.5));
            this.colModel.prefWidthProperty().bind((ObservableValue)this.deviceTable.widthProperty().subtract(40).divide(7.142857142857142).subtract(0.5));
            this.colVersion.prefWidthProperty().bind((ObservableValue)this.deviceTable.widthProperty().subtract(40).divide(7.142857142857142).subtract(0.5));
            this.colStatus.prefWidthProperty().bind((ObservableValue)this.deviceTable.widthProperty().subtract(40).divide(7.692307692307692).subtract(0.5));
            this.colSetting.prefWidthProperty().bind((ObservableValue)this.deviceTable.widthProperty().subtract(40).divide(7.142857142857142).subtract(0.5));
        }
    }

    private void a(DeviceModel model) {
        com.tplink.utility.discovery.ui.a.d page = new com.tplink.utility.discovery.ui.a.d(model);
        com.tplink.utility.discovery.ui.a.b().a((Region)page);
    }

    @FXML
    public void searchDevice(ActionEvent event) {
        String searchKey = this.searcher.getText().trim();
        this.a(searchKey);
    }

    @FXML
    public void clearDevice(ActionEvent event) {
        com.tplink.utility.discovery.context.d.d();
        this.deviceTable.setItems(com.tplink.utility.discovery.context.d.b());
    }

    @FXML
    public void batchSettingFired(ActionEvent event) {
        boolean isAnySelected = false;
        ObservableList devices = d.c((String)d.a());
        ArrayList<DeviceModel> selectedDevices = new ArrayList<DeviceModel>();
        if (!CollectionUtils.isEmpty((Collection)devices)) {
            for (int i2 = 0; i2 < devices.size(); ++i2) {
                DeviceModel device = (DeviceModel)this.deviceTable.getItems().get(i2);
                if (!device.getSelected()) continue;
                selectedDevices.add(device);
                isAnySelected = true;
            }
        }
        if (!isAnySelected) {
            Msg.setTitle((String)com.tplink.utility.discovery.b.a.a((String)"discover.window.title"));
            Msg.a((String)com.tplink.utility.discovery.b.a.a((String)"g.error.selectAp"));
            return;
        }
        new com.tplink.utility.discovery.ui.a.a(selectedDevices);
        com.tplink.utility.discovery.ui.a.b().a((Region)com.tplink.utility.discovery.ui.a.f());
    }

    @FXML
    public void selectAllFired(ActionEvent event) {
        DeviceModel device;
        int i2;
        boolean isAllSelected = true;
        ObservableList devices = this.deviceTable.getItems();
        if (!CollectionUtils.isEmpty((Collection)devices)) {
            if (com.tplink.utility.server.c.a.a((Object)((DeviceModel)devices.get(0)).getMac())) {
                return;
            }
            for (i2 = 0; i2 < devices.size(); ++i2) {
                device = (DeviceModel)this.deviceTable.getItems().get(i2);
                if (device.getSelected()) continue;
                isAllSelected = false;
                break;
            }
        }
        if (!isAllSelected) {
            for (i2 = 0; i2 < devices.size(); ++i2) {
                device = (DeviceModel)this.deviceTable.getItems().get(i2);
                device.setSelected(true);
                com.tplink.utility.discovery.context.d.b((String)device.getMac()).setSelected(true);
            }
        } else {
            for (i2 = 0; i2 < devices.size(); ++i2) {
                device = (DeviceModel)this.deviceTable.getItems().get(i2);
                device.setSelected(false);
                com.tplink.utility.discovery.context.d.b((String)device.getMac()).setSelected(false);
            }
        }
    }

    static /* synthetic */ TableView a(DiscoveryController x0) {
        return x0.deviceTable;
    }

    static /* synthetic */ void a(DiscoveryController x0, DeviceModel x1) {
        x0.a(x1);
    }
}

