/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.utility.discovery.controller;

import com.jfoenix.controls.JFXButton;
import com.tplink.smb.ecsp.common.DeviceType;
import com.tplink.utility.common.obfuscate.KeepClass;
import com.tplink.utility.common.protocol.packet.body.datagram.BaseConfigRequest;
import com.tplink.utility.discovery.context.b;
import com.tplink.utility.discovery.context.d;
import com.tplink.utility.discovery.context.model.DeviceModel;
import com.tplink.utility.discovery.context.model.DeviceSetting;
import com.tplink.utility.discovery.context.model.DeviceStatus;
import com.tplink.utility.discovery.controller.a;
import com.tplink.utility.discovery.d.e;
import com.tplink.utility.discovery.d.g;
import com.tplink.utility.discovery.d.h;
import com.tplink.utility.discovery.d.i;
import com.tplink.utility.discovery.event.EventQueueManager;
import com.tplink.utility.discovery.ui.Msg;
import com.tplink.utility.server.cache.AdoptInfoDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@KeepClass
public class BatchSettingController
implements a {
    private static final Logger log = LoggerFactory.getLogger(BatchSettingController.class);
    @FXML
    private TitledPane titledPane;
    @FXML
    private StackPane mainStackPane;
    @FXML
    private AnchorPane batchSettingMainPane;
    @FXML
    private Label setInformIp;
    @FXML
    private Label username;
    @FXML
    private Label password;
    @FXML
    private TextField usernameField;
    @FXML
    private TextField setInformIpField;
    @FXML
    private PasswordField passwordField;
    @FXML
    private HBox buttonBox;
    @FXML
    private JFXButton apply;
    @FXML
    private JFXButton cancel_0;
    @FXML
    private AnchorPane batchSettingStatusPane;
    @FXML
    private HBox progressBox;
    @FXML
    private Label progressLabel;
    @FXML
    private Label progressValLabel;
    @FXML
    private TextArea output;
    @FXML
    private JFXButton cancel_1;
    private List<DeviceModel> deviceList;
    private double mouseDragOffsetX;
    private double mouseDragOffsetY;
    private static ExecutorService singleThreadExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    private final String BATCHTITLE = "batch.window.title";

    public void onCreate() {
        double msgW = this.titledPane.getPrefWidth();
        double msgH = this.titledPane.getPrefHeight();
        this.cancel_0.setOnAction(actionEvent -> com.tplink.utility.discovery.ui.a.b().a());
        this.cancel_1.setOnAction(actionEvent -> com.tplink.utility.discovery.ui.a.b().a());
        if (com.tplink.utility.discovery.context.a.e()) {
            this.a(0);
        }
        this.titledPane.setOnMousePressed(mouseEvent -> {
            this.mouseDragOffsetX = mouseEvent.getX();
            this.mouseDragOffsetY = mouseEvent.getY();
        });
        this.titledPane.setOnMouseDragged(mouseEvent -> {
            this.titledPane.setLayoutX(mouseEvent.getSceneX() - this.mouseDragOffsetX - (com.tplink.utility.discovery.ui.a.a().a() - msgW) / 2.0);
            this.titledPane.setLayoutY(mouseEvent.getSceneY() - this.mouseDragOffsetY - (com.tplink.utility.discovery.ui.a.a().b() - msgH) / 2.0);
        });
        this.apply.setDisable(true);
        g.a((Node)this.apply, (TextField[])new TextField[]{this.passwordField, this.setInformIpField, this.usernameField});
        this.apply.setOnAction(actionEvent -> this.a((Button)this.apply));
        this.batchSettingMainPane.setOnKeyPressed(keyEvent -> {
            if (keyEvent.getCode() == KeyCode.ENTER && !this.apply.isDisabled()) {
                this.a((Button)this.apply);
                keyEvent.consume();
            }
        });
        g.a((Node)this.setInformIpField);
    }

    public void setDeviceList(List<DeviceModel> deviceList) {
        this.deviceList = deviceList;
    }

    private void a(int DeviceNum) {
        if (DeviceNum != 0) {
            this.progressValLabel.setText(this.a(0, DeviceNum));
            this.output.setText("");
        } else {
            this.progressValLabel.setText(com.tplink.utility.discovery.context.a.c.getValue());
            this.output.setText(com.tplink.utility.discovery.context.a.b.getValue());
        }
        com.tplink.utility.discovery.context.a.b.addListener((arg0, oldS, newStr) -> Platform.runLater(() -> this.output.setText(newStr)));
        com.tplink.utility.discovery.context.a.c.addListener((arg0, oldS, newStr) -> Platform.runLater(() -> this.progressValLabel.setText(newStr)));
        com.tplink.utility.discovery.context.a.a.addListener((observableValue, aBoolean, t1) -> this.cancel_1.setDisable(t1.booleanValue()));
        this.cancel_1.setDisable(com.tplink.utility.discovery.context.a.e());
        this.batchSettingMainPane.setVisible(false);
        this.batchSettingStatusPane.setVisible(true);
    }

    private void a(Button apply) {
        if (!i.d((String)this.setInformIpField.getText())) {
            Msg.setTitle((String)com.tplink.utility.discovery.b.a.a((String)"batch.window.title"));
            Msg.a((String)com.tplink.utility.discovery.b.a.a((String)"setting.error.invalidHostname"));
            return;
        }
        if (d.a().isEmpty()) {
            Msg.setTitle((String)com.tplink.utility.discovery.b.a.a((String)"batch.window.title"));
            Msg.a((String)com.tplink.utility.discovery.b.a.a((String)"setting.error.noAp"));
            return;
        }
        for (DeviceModel device : this.deviceList) {
            if (device.getReachable()) continue;
            com.tplink.utility.discovery.ui.a.b().a();
            Msg.setTitle((String)com.tplink.utility.discovery.b.a.a((String)"batch.window.title"));
            Msg.a((String)("Device " + device.getMac() + " " + com.tplink.utility.discovery.b.a.a((String)"g.error.devicesBusy")));
            log.debug("Device {} is busy, please retry later.", (Object)device.getMac());
            return;
        }
        apply.setDisable(true);
        if (!CollectionUtils.isEmpty((Collection)this.deviceList)) {
            if (com.tplink.utility.discovery.context.a.e()) {
                Msg.setTitle((String)com.tplink.utility.discovery.b.a.a((String)"batch.window.title"));
                Msg.a((String)com.tplink.utility.discovery.b.a.a((String)"setting.error.batchSetting"));
                return;
            }
            this.a(this.deviceList.size());
            this.a(this.usernameField.getText(), this.passwordField.getText(), this.setInformIpField.getText());
        } else {
            Msg.setTitle((String)com.tplink.utility.discovery.b.a.a((String)"batch.window.title"));
            Msg.a((String)com.tplink.utility.discovery.b.a.a((String)"setting.error.noAp"));
        }
    }

    private void a(String username, String password, String informIp) {
        int retryTimes = this.a();
        log.debug("Do batch adopting, list size is {}", (Object)this.deviceList.size());
        singleThreadExecutor.execute(() -> {
            Object lock;
            ExecutorService pool = h.a();
            Object object = lock = com.tplink.utility.discovery.context.a.f();
            synchronized (object) {
                com.tplink.utility.discovery.context.a.a((boolean)true);
                this.b(this.deviceList);
            }
            int cur = 0;
            while (cur <= retryTimes) {
                ArrayList DeviceMacList;
                ArrayList devices;
                if (++cur != 1 && !this.e()) {
                    log.debug("No batch adopting device");
                    break;
                }
                if (cur == 1) {
                    devices = new ArrayList(com.tplink.utility.discovery.context.a.a().values());
                    DeviceMacList = new ArrayList(com.tplink.utility.discovery.context.a.a().keySet());
                } else {
                    devices = com.tplink.utility.discovery.context.a.b();
                    DeviceMacList = com.tplink.utility.discovery.context.a.c();
                }
                log.info("the {} times to batch adopt aps , remaining size is : {} ", (Object)cur, (Object)devices.size());
                this.a(username, password, informIp, devices, pool);
                this.a(DeviceMacList);
            }
            Object object2 = lock;
            synchronized (object2) {
                this.b();
            }
            h.b();
        });
    }

    private void a(String username, String password, String informIp, List<DeviceModel> devices, ExecutorService batchAdoptExecutor) {
        if (null == batchAdoptExecutor) {
            Platform.runLater(() -> {
                Msg.setTitle((String)com.tplink.utility.discovery.b.a.a((String)"batch.window.title"));
                Msg.a((String)com.tplink.utility.discovery.b.a.a((String)"setting.error.batchSys"));
            });
            return;
        }
        for (DeviceModel device : devices) {
            batchAdoptExecutor.execute(() -> {
                log.debug("start to adopt mac: {}", (Object)device.getMac());
                com.tplink.utility.common.c.a authentication = new com.tplink.utility.common.c.a(username, password, device.getMac(), device.getIp());
                AdoptInfoDTO adoptInfoDTO = new AdoptInfoDTO(authentication, device.getType(), device.getEcspVersion());
                com.tplink.utility.server.cache.a.a((String)device.getMac(), (AdoptInfoDTO)adoptInfoDTO);
                this.a(device.getMac(), device.getIp(), username, password, informIp);
            });
            try {
                int adoptFrequency = this.c();
                if (adoptFrequency <= 0) continue;
                TimeUnit.MILLISECONDS.sleep(this.c());
            }
            catch (InterruptedException e2) {
                log.error("Exception :", (Throwable)e2);
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(String mac, String ip, String username, String password, String informIp) {
        boolean checked = this.a(mac, informIp);
        if (!checked) {
            log.debug("Check device status not ok for mac: {}", (Object)mac);
            return;
        }
        DeviceModel device = com.tplink.utility.discovery.context.a.b((String)mac);
        device.setStatus(DeviceStatus.ADOPTING.getName());
        device.setLastSeen(Long.valueOf(System.currentTimeMillis()));
        com.tplink.utility.discovery.event.a msg = new com.tplink.utility.discovery.event.a(device.getMac(), com.tplink.utility.discovery.event.b.a, device);
        try {
            EventQueueManager.a((com.tplink.utility.discovery.event.a)msg);
            com.tplink.utility.common.c.a authentication = new com.tplink.utility.common.c.a();
            authentication.d(ip);
            authentication.c(mac);
            authentication.a(username);
            authentication.b(password);
            if ("v1".equals(device.getProtocolVersion())) {
                com.tplink.utility.discovery.event.d.a((com.tplink.utility.a.a.h)com.tplink.utility.a.a.h.l, com.tplink.utility.common.c.a.class, (Object)authentication, (String)mac, (String)device.getEcspVersion(), (DeviceType)device.getType());
            } else if ("v2".equals(device.getProtocolVersion())) {
                com.tplink.utility.discovery.event.d.a((com.tplink.utility.a.a.h)com.tplink.utility.a.a.h.p, com.tplink.utility.common.c.a.class, (Object)authentication, (String)mac, (String)device.getEcspVersion(), (DeviceType)device.getType());
            }
        }
        catch (InterruptedException e2) {
            Object lock;
            log.error("Exception: ", (Throwable)e2);
            Object object = lock = com.tplink.utility.discovery.context.a.f();
            synchronized (object) {
                com.tplink.utility.discovery.context.a.a((String)mac);
                d.c((String)mac);
            }
            Thread.currentThread().interrupt();
        }
    }

    private int a() {
        return 2;
    }

    private void b() {
        List failedDevices = com.tplink.utility.discovery.context.a.b();
        log.debug("Clean adopt failed aps: {}", (Object)failedDevices.size());
        for (DeviceModel device : failedDevices) {
            String mac = device.getMac();
            int totalNum = com.tplink.utility.discovery.context.a.d();
            int currentNum = com.tplink.utility.discovery.context.a.a().size();
            com.tplink.utility.discovery.context.a.a((String)mac, (String)device.getStatus());
            com.tplink.utility.discovery.context.a.a((int)totalNum, (int)currentNum);
            com.tplink.utility.discovery.context.a.a((String)mac);
        }
        com.tplink.utility.discovery.context.a.g();
    }

    private void a(List<String> apMacList) {
        try {
            Thread.sleep(1000L);
            while (this.c(apMacList) || this.d()) {
                log.debug("processing , please waiting...");
                Thread.sleep(500L);
            }
        }
        catch (Exception e2) {
            log.warn("exception .", (Throwable)e2);
            Thread.currentThread().interrupt();
        }
    }

    private int c() {
        return 10;
    }

    private void b(List<DeviceModel> devices) {
        for (DeviceModel device : devices) {
            DeviceModel newAP = this.a(device);
            newAP.setStatus(DeviceStatus.ADOPTING.getName());
            com.tplink.utility.discovery.context.a.a((String)device.getMac(), (DeviceModel)newAP);
        }
        com.tplink.utility.discovery.context.a.a((int)this.deviceList.size());
        com.tplink.utility.discovery.context.a.c((String)"end");
        com.tplink.utility.discovery.context.a.d((String)this.a(0, com.tplink.utility.discovery.context.a.d()));
    }

    private DeviceModel a(DeviceModel device) {
        DeviceModel deviceModel = b.a((String)device.getMac(), (DeviceType)device.getType(), (String)device.getProtocolVersion(), null);
        deviceModel.setMac(device.getMac());
        deviceModel.setIp(device.getIp());
        deviceModel.setModel(device.getModel());
        deviceModel.setVersion(device.getVersion());
        deviceModel.setStatus(device.getStatus());
        deviceModel.setSelected(device.getSelected());
        deviceModel.setControllerId(device.getControllerId());
        deviceModel.setEcspVersion(device.getEcspVersion());
        return deviceModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean a(String mac, String informIp) {
        DeviceModel deviceContext = d.b((String)mac);
        String state = deviceContext == null ? "null" : deviceContext.getStatus();
        log.debug("Device for mac: {} , state is: {}", (Object)mac, (Object)state);
        if (deviceContext == null) {
            Object lock;
            int totalNum = com.tplink.utility.discovery.context.a.d();
            int currentNum = com.tplink.utility.discovery.context.a.a().size();
            com.tplink.utility.discovery.context.a.a((String)mac, (String)com.tplink.utility.discovery.b.a.a((String)"g.error.deviceBusy"));
            com.tplink.utility.discovery.context.a.a((int)totalNum, (int)currentNum);
            Object object = lock = com.tplink.utility.discovery.context.a.f();
            synchronized (object) {
                com.tplink.utility.discovery.context.a.a((String)mac);
            }
            return false;
        }
        if (this.a(mac)) {
            Object lock;
            int totalNum = com.tplink.utility.discovery.context.a.d();
            int currentNum = com.tplink.utility.discovery.context.a.a().size();
            com.tplink.utility.discovery.context.a.a((String)mac, (String)com.tplink.utility.discovery.b.a.a((String)"g.error.adopt"));
            com.tplink.utility.discovery.context.a.a((int)totalNum, (int)currentNum);
            Object object = lock = com.tplink.utility.discovery.context.a.f();
            synchronized (object) {
                com.tplink.utility.discovery.context.a.a((String)mac);
            }
            return false;
        }
        BaseConfigRequest configBody = e.a((String)informIp, (DeviceType)deviceContext.getType(), (String)deviceContext.getProtocolVersion());
        DeviceSetting deviceSetting = new DeviceSetting(configBody, DeviceStatus.PENDING, e.a((String)this.setInformIpField.getText()));
        d.a((String)mac, (DeviceSetting)deviceSetting);
        return true;
    }

    private boolean c(List<String> apMacList) {
        for (String mac : apMacList) {
            if (d.b((String)mac) != null) {
                String status = d.b((String)mac).getStatus();
                if (!DeviceStatus.CONFIGURING.getName().equals(status) && !DeviceStatus.ADOPTING.getName().equals(status)) continue;
                return true;
            }
            log.debug("device {} is removed from ram.", (Object)mac);
        }
        return false;
    }

    private boolean d() {
        for (Map.Entry entry : com.tplink.utility.discovery.context.a.a().entrySet()) {
            if (!((DeviceModel)entry.getValue()).isAdopting()) continue;
            return true;
        }
        return false;
    }

    private boolean e() {
        for (Map.Entry entry : com.tplink.utility.discovery.context.a.a().entrySet()) {
            if (!((DeviceModel)entry.getValue()).isAdoptFailed()) continue;
            return true;
        }
        return false;
    }

    private boolean a(String mac) {
        DeviceModel device = d.b((String)mac);
        return device != null && DeviceStatus.CONFIGURING.getName().equals(device.getStatus());
    }

    private String a(int current, int total) {
        return current + "/" + total;
    }
}

