/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.utility.discovery.context.model;

import com.tplink.smb.ecsp.common.DeviceType;
import com.tplink.utility.common.obfuscate.KeepClass;
import com.tplink.utility.discovery.context.model.DeviceStatus;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;

@KeepClass
public class DeviceModel {
    private final SimpleStringProperty mac;
    private final SimpleStringProperty ip;
    private final SimpleStringProperty model;
    private final SimpleStringProperty version;
    private final SimpleStringProperty status;
    private final SimpleStringProperty settingButton;
    private final SimpleBooleanProperty reachable;
    private final SimpleBooleanProperty selected;
    private DeviceType type;
    private String protocolVersion;
    private String controllerId;
    private Integer configVersion;
    private Long lastSeen;
    private String ecspVersion;

    public DeviceModel(String mac, String ip, String model, String version, String status, String settingButton, boolean reachable, boolean selected, DeviceType type, String protocolVersion) {
        this.mac = new SimpleStringProperty(mac);
        this.ip = new SimpleStringProperty(ip);
        this.model = new SimpleStringProperty(model);
        this.version = new SimpleStringProperty(version);
        this.status = new SimpleStringProperty(status);
        this.settingButton = new SimpleStringProperty(settingButton);
        this.selected = new SimpleBooleanProperty(reachable);
        this.reachable = new SimpleBooleanProperty(selected);
        this.type = type;
        this.protocolVersion = protocolVersion;
        this.lastSeen = System.currentTimeMillis();
    }

    public String getMac() {
        return this.mac.get();
    }

    public SimpleStringProperty macProperty() {
        return this.mac;
    }

    public void setMac(String mac) {
        this.mac.set(mac);
    }

    public String getIp() {
        return this.ip.get();
    }

    public SimpleStringProperty ipProperty() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip.set(ip);
    }

    public String getModel() {
        return this.model.get();
    }

    public SimpleStringProperty modelProperty() {
        return this.model;
    }

    public void setModel(String model) {
        this.model.set(model);
    }

    public String getVersion() {
        return this.version.get();
    }

    public SimpleStringProperty versionProperty() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version.set(version);
    }

    public String getStatus() {
        return this.status.get();
    }

    public SimpleStringProperty statusProperty() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status.set(status);
    }

    public String getSettingButton() {
        return this.settingButton.get();
    }

    public SimpleStringProperty settingButtonProperty() {
        return this.settingButton;
    }

    public void setSettingButton(String settingButton) {
        this.settingButton.set(settingButton);
    }

    public boolean getSelected() {
        return this.selected.get();
    }

    public SimpleBooleanProperty selectedProperty() {
        return this.selected;
    }

    public void setReachable(boolean reachable) {
        this.reachable.set(reachable);
    }

    public boolean getReachable() {
        return this.reachable.get();
    }

    public SimpleBooleanProperty reachableProperty() {
        return this.reachable;
    }

    public void setSelected(boolean selected) {
        this.selected.set(selected);
    }

    public boolean isStatusFinished() {
        return this.getStatus().equals(DeviceStatus.ADOPT_FAIL.getName()) || this.getStatus().equals(DeviceStatus.ADOPT_TIMEOUT.getName()) || this.getStatus().equals(DeviceStatus.SETTING_FAIL.getName()) || this.getStatus().equals(DeviceStatus.SETTING_SUCCEED.getName()) || this.getStatus().equals(DeviceStatus.AP_UNREACHABLE.getName());
    }

    public boolean isConfiguring() {
        return this.getStatus().equals(DeviceStatus.CONFIGURING.getName());
    }

    public boolean isAdopting() {
        return this.getStatus().equals(DeviceStatus.ADOPTING.getName());
    }

    public boolean isPending() {
        return this.getStatus().equals(DeviceStatus.PENDING.getName());
    }

    public boolean isAdoptFailed() {
        return this.getStatus().equals(DeviceStatus.ADOPT_FAIL.getName()) || this.getStatus().equals(DeviceStatus.ADOPT_TIMEOUT.getName());
    }

    public void setType(DeviceType type) {
        this.type = type;
    }

    public DeviceType getType() {
        return this.type;
    }

    public void setProtocolVersion(String protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setControllerId(String controllerId) {
        this.controllerId = controllerId;
    }

    public String getControllerId() {
        return this.controllerId;
    }

    public void setConfigVersion(Integer configVersion) {
        this.configVersion = configVersion;
    }

    public Integer getConfigVersion() {
        return this.configVersion;
    }

    public void setLastSeen(Long lastSeen) {
        this.lastSeen = lastSeen;
    }

    public Long getLastSeen() {
        return this.lastSeen;
    }

    public void setEcspVersion(String ecspVersion) {
        this.ecspVersion = ecspVersion;
    }

    public String getEcspVersion() {
        return this.ecspVersion;
    }
}

